$('#notes').click(function() {
    $('.screen').hide();
    $('.notes-screen').show();
});

$("#closeNotes").click(function() {
    $('.notes-screen').hide();
    $('.screen').show();
});

$('#wootpod').click(function() {
    $('.screen').hide();
    $('.wootpod-screen').show();
});

$('#closeWootpod').click(function() {
    $('.wootpod-screen').hide();
    $('.screen').show();
});

$('#photos').click(function() {
    $('.screen').hide();
    $('.photos-screen').show();
});

$('#closePhotos').click(function() {
    $('.photos-screen').hide();
    $('.screen').show();
});

$('#voice').click(function() {
    $('.screen').hide();
    $('.voice-screen').show();
});

$('#closeVoice').click(function() {
    $('.voice-screen').hide();
    $('.screen').show();
});

$('#messages').click(function() {
    storyBegins = false;
    saveState();

    $('.screen').hide();

    $("#message-list").html("");
    for (var m=0; m < displayedMessages.length; m++) {
        var messageData = getMessageById(displayedMessages[m]);
        if (messageData.amberMessage)
            $("#message-list").append("<div class='alert alert-info'><b><em>Amber says: </em></b>" + messageData.text + "</div>");
        else
            $("#message-list").append("<div class='alert alert-success alert-right'><b><em>You say: </em></b>" + messageData.text + "</div>");
    }

    unreadMessageCount = 0;
    updateMessageBadge(false, unreadMessageCount);

    if (conversationStarted) {
        var lastId = displayedMessages[displayedMessages.length-1];
        var messageData = getMessageById(lastId);

        for (var m=0; m < messageData.options.length; m++) {
            var buttonData = getMessageById(messageData.options[m]);
            $("#message-answers-wrapper").append("<button onclick='clickAnswer(" + buttonData.id + ");' class='btn btn-primary answer' id='" + buttonData.tag + "'>" + buttonData.text + "</button>");
        }
    }

    $('.messages-screen').show();
});

var clickAnswer = function(id) {
    var buttonData = getMessageById(id);
    setMessageViewed(buttonData.id);
    $("#message-list").append("<div class='alert alert-success alert-right'><b><em>You say: </em></b>" + buttonData.text + "</div>");
    setMessageViewed(buttonData.id);
    displayedMessages.push(buttonData.id)

    var responseData = getMessageById(buttonData.gotoPage);
    $("#message-list").append("<div class='alert alert-info'><b><em>Amber says: </em></b>" + responseData.text + "</div>");
    setMessageViewed(responseData.id);
    displayedMessages.push(responseData.id);

    if (responseData.options[0] == -99) {
        conversationStarted = false;
        $("#closeMessages").show();
        $("#message-answers-wrapper").hide();
        $("#keyboard-image").hide();
        $(".messages-screen").height('90%');
        $("#message-list").height('90%');
        saveState();
        return;
    }
    saveState();

    // Reset buttons...
    $("#message-answers-wrapper").html("");
    for (var m=0; m < responseData.options.length; m++) {
        var nextButtonData = getMessageById(responseData.options[m]);
        $("#message-answers-wrapper").append("<button onclick='clickAnswer(" + nextButtonData.id + ");' class='btn btn-primary answer' id='" + nextButtonData.tag + "'>" + nextButtonData.text + "</button>");
    }
};

$('#closeMessages').click(function() {
    $('.messages-screen').hide();
    $('.screen').show();
});

$('.thumbnail').click(function(e) {
    var id = e.currentTarget.id;

    $("#photoBody").html("");

    switch (id) {
        case "birdPhoto":
            viewedPhotos[0] = true;
            $("#photoBody").html("<img src='photos/bird.png' width='270px'/>");
            break;
        case "dogPhoto":
            viewedPhotos[1] = true;
            $("#photoBody").html("<img src='photos/dog.png' width='270px'/>");
            break;
        case "dirtPhoto":
            viewedPhotos[2] = true;
            $("#photoBody").html("<img src='photos/dirt.png' width='270px'/>");
            break;
        case "fbPhoto":
            viewedPhotos[3] = true;
            $("#photoBody").html("<img src='photos/footballStands.png' width='270px'/>");
            break;
        case "funnyStoryPhoto":
            viewedPhotos[4] = true;
            $("#photoBody").html("<img src='photos/funny-story.png' width='270px'/>");
            break;
        case "loveNotePhoto":
            viewedPhotos[5] = true;
            $("#photoBody").html("<img src='photos/iloveyounote.png' width='270px'/>");
            break;
        case "jackPhoto":
            viewedPhotos[6] = true;
            $("#photoBody").html("<img src='photos/jacksepticeye.png' width='270px'/>");
            break;
        case "jackhpPhoto":
            viewedPhotos[7] = true;
            $("#photoBody").html("<img src='photos/jacksepticeye-headphones.png' width='270px'/>");
            break;
        case "jackSexyPhoto":
            viewedPhotos[8] = true;
            $("#photoBody").html("<img src='photos/jacksepticeye-sexypose.png' width='270px'/>");
            break;
        case "marcoplierPhoto":
            viewedPhotos[9] = true;
            $("#photoBody").html("<img src='photos/marcoplier.png' width='270px'/>");
            break;
        case "mtPhoto":
            viewedPhotos[10] = true;
            $("#photoBody").html("<img src='photos/mt-crying.png' width='270px'/>");
            break;
        case "sunsetPhoto":
            viewedPhotos[11] = true;
            $("#photoBody").html("<img src='photos/sunset.png' width='270px'/>");
            break;
    }

    $('#photoModal').on('hidden.bs.modal', function () {
        $("#photoGallery").show();
    });
    $("#photoModal").modal();
});

$('.note').click(function(e) {
    var id = e.currentTarget.id;

    $("#noteTitle").text(e.target.innerText);
    $("#noteBody").html('');

    switch (id) {
        case 'note-1':
            viewedNotes[0] = true;
            $("#noteBody").html("<span class='italics'>No longer will I play this game. I have suffered immensely and have been broken and bombed inside. No longer will this game continue, because I am no longer playing it. Their rein on us has begun to show through their bright and fake smiles, but now is our time to show them. We make them think we adore them, but we don't. And I'll make that very clear. They won't control us, steal what was once ours, or turn our friends against us. Some of us have begun to realize that this silent war, shall not end until we've put up a fight. We are the soldiers, that fight every day and every night for what we believe in. And we want to make this change so bad, that we would die for it. I believe that these people can change. That they will come out from their huddles, silence their whispers, and look out and see what they have become. I, Mikayla, shall put an end to their grasp on us. I shall save everyone from constant fighting. I shall not have people judging others because of how they act or what they wear or even how rich they are. Why can't they understand that this game has gone on dangerous ground? But no matter how much I warn them, they won't listen. Some day, they're minds will change and us dorks will never have to live up to that name again. We will thrive in the bright light the way we did back in elementary school. We can end this. And I'm going to start now.</span>");
            break;
        case 'note-2':
            viewedNotes[1] = true;
            $("#noteBody").html("<strong>The List</strong><br/>The people who hate me<br/>The people who've struck me<br/>People who have turned me into a monster<br/>The people who are playing a dangerous game with me");
            break;
        case 'note-3':
            viewedNotes[2] = true;
            $("#noteBody").html("<span class='italics'>I'm all alone in my bedroom waiting till the clock on the stove strikes 5:30pm. That means I get to use a lovely laptop to type on and also update people on stories that exist on there. Summer can kinda be boring. First off, no Mianite cause of course everyone is going to conventions that I can't attend. Secondly, there is absolutely nothing for me to do except wait for my friends' arrivals from all over the US! I personally still have to wait again, for another long period of time before exiting the state of Illinois for yes, ANOTHER extended amount of time. I even think my family has started talking about how I waste my summer watching, oh, what's the word? VIDEOS. Thanks everyone! Welp, I guess I should be going. Showers can't take themselves!</span>");
            break;
        case 'note-4':
            viewedNotes[3] = true;
            $("#noteBody").html("<span class='italics'>Everybody has plan. A plan for the future that will blossom into a perfect or terrible path. But there's just one problem, everybody made their own plan. Me, on the other hand, have gone to roads other people chose for me. And not because I'm lazy. I was dragged against my will to do something everyone thought was right. These people believed that I was heading to Doomsville, only because they just didn't seem to like my decisions. And that's just how my life went. Not only did I not get to direct my own life, I never got to say anything about it. The whole thing was just done for me. And I absolutely hated it. And it's because I'm supposed to be the one directing where I go or to make plans for the future. But the people against my ideas are the ones who control me. And look at me now. I'm 13 years old and I don't even know what I want to be when I grow up. Because it seems to me, I can't do something I want to do. Which puts me in a difficult spot in which I never get the chance to try something new without everybody telling me to. I'm trying to get my voice back. This time, I really am.</span>");
            showMessage("note-4", false);
            break;
        case 'note-5':
            viewedNotes[4] = true;
            $("#noteBody").html("<span class='italics'>Long days, long weeks. With school storming through, I feel like a different person. I walk faster, I run faster. Everyday goes by like it does, nothing different, nothing changing. It'll always be this way, you live, you love, you lose. Time may not ever be your friend. Neither can the world around you. Temptations become too harsh, happiness seems to thin, and everyone seems to lose themselves amongst the brightness of a screen. And I can't help it either, it's too addictive. I can't find another way to put my ePhone down, and that's what makes the companies so happy. They've created a digital drug.</span> ");
            showMessage("note-5", false);
            break;
        case 'note-6':
            viewedNotes[5] = true;
            $("#noteBody").html("<span class='italics'>I write this without knowing what I am actually writing about. It's wierd I know. Things have been going great for me these past few days, no homework, no sports. Nothing but relaxation and cranky siblings after school. There is one thing that keeps showing itself to me. One thing that I absolutely hate. It's when my mind has lost all common sense and I'm left with bare and utter thoughts clinging to me like they're going to fall off. I'm sure as hell that's not the case. These particular thoughts make the evil part of me grow. It's like being on your period, just multiply the mood swings by 10 and that should be where I am. The thoughts keep twisting and turning for awhile until my brain figures out a way to make them seem realistic. Which then has me at a crossroads. My gullible side of course goes towards the DANGER section of my mind, feeling welcomed by the now approaching self pity. All of this said and done, the next step is to wail like never before. Because all of the pain these thoughts cause me, is seeping through into deep horrendous sobs. I have learned to halt and to not take the bait in front of me sometimes, other times I just do it because the temptation is too strong, and I can't fight back enough. The one thing that seems to come every time I try to explain why I cry or cried so much, is well, and here are the thoughts talking and about 60% of me talking, no one listens.</span>");
            break;
        case 'note-7':
            viewedNotes[6] = true;
            $("#noteBody").html("<span class='italics'>I sit on a comfy couch in a generic waiting room, watching the time tick by slowly. The soon coming appointment seems to come closer towards the exact second where I'm let in through the large door, getting ready for my check-up. I tend to not get nervous for these types of things because of course there was nothing I needed to worry about. Even the shots they give you every couple of years don't really scare me. But this year, things are different. I started puberty, I might have a problem in the weight department, and also nausea won't stop coming through. There was something else that I was going to say, but just as I was about to type it in, the friendly nurse called our names and the appointments began.");
            showMessage("note-7", false);
            break;
        case 'note-8':
            viewedNotes[7] = true;
            $("#noteBody").html("<span class='italics'>Some day I'll be able to fly. Off to a far away place where there's no screaming and shouting. Demanding that I need to do this or I need to prepare that. I want to fly, high above the clouds, where no one will ever find me. Just so that I can escape the things that hurt me most. Mckay. He charms the pants off of me, yet I still can't get his attention. I confine myself, and talk self-conciously about myself. He makes me want to dress nicer or look like I'm trying to impress someone. That is not what I want to become. That's why I want to fly. To find myself, my passion, my lover, and everything that will make my future happier than this. I don't like Mckay like I did last year, I don't try to run faster because I want to show off, and I especially don't want to look at myself and ask if I'm fat or does my hair look flawless. I shouldn't care what I look like, because all I know, is that all that will bring me is neglect. Not by other people, but me. I'm the only bully that really exists, not my family, not the populars, but me. Part of me flies away, the part that wants to, but this very part of me stays, because this me knows how much everything here matters. No matter how stressful or painful it may be. All I have to say is this, I flew away to a far off place, away from the demands and shouts. I flew away to a place I can calm down and find where I belong. That place is not there, it's here. I know that now, I wish the rest of my family knew about it.</span>");
            break;
        case 'note-9':
            viewedNotes[8] = true;
            $("#noteBody").html("<span class='italics'>Tick tock. Time is running out. Tick tock, school is almost out. No more time, no more time. It's all gone.</span>");
            break;
        case 'note-10':
            viewedNotes[9] = true;
            $("#noteBody").html("<span class='italics'>Time being wasted, time spent, whatever it is I'm using it to be pissed. Just some things can be hard to handle in my house. With rules I don't appreciate and annoying mothers I've had to deal with everyday. For once, I want to write about it. With clocks all around stating that it's time for something. I hate clocks. They keep reminding me that I'm running out of time, that there's something that'll somehow spontaneously ruin me. My own mom is clock for crying out loud! She's never an accurate one though. She'll say things like, &quot;you've been in here for hours!&quot; or, &quot;it's noon and you still haven't left your room&quot; All of it, every single comment coming from that woman's mouth makes me tense up. Just something about her even being near me makes me want to explode.</span>");
            break;
        case 'note-11':
            viewedNotes[10] = true;
            $("#noteBody").html("<span class='italics'>Several things to do yet I hate it all. There are many things I want to do, but they hate it all. Can't speak about lots of things because not everyone is able to join, but the one rule in the house I reside in is if you're upstairs, you miss out. No dessert, no games, just disappointed faces. &quot;Can't you see what you're doing?!&quot; they ask in a raging voice. &quot;No,&quot; I'd say, &quot;Tell me what I'm doing wrong.&quot; They'll quiet down and eventually continue on with their lives while I remain unanswered. I hate it when I can't scream, I feel the urge every time someone looks at me, sympathy, disappointment, and disgust of what I am and what I've become. I can't change, I can't bring myself to do it. There are many things in this world that I am afraid of losing. My happiness is one of them. I am empathetic, I can lose my own sense of feeling and can feeling other peoples' emotions. Sadness occurs most often, not only because I am a sad child, but the feeling lingers in books I read and people I have met. The one thing I am unable to do for any real reason is cry. From my mother's constant screaming and punishments of locking me in the bathroom have become accustomed to me. Like teaching a dog not to wag it's tail, but this time it's worse. My sister tells me, you can cry, no one is stopping you.</span>");
            break;
        case 'note-11a':
            viewedNotes[11] = true;
            $("#noteBody").html("<span class='italics'>But yet there's a barrier that I can't break. When I was younger I misunderstood my mother and as she yelled at me to be quiet, I started to force myself to never cry, never shed a tear. I had a fear and I still do, that if I cry, someone somewhere will come to punish me, to take me away to a far off land where I'll be whipped and hung for the whole world to see. With everyone shouting their cries of desperate pleas, to let me live, but my soon to be punishers give no mercy. They smile, and chuckle as they raise the knife the knife, giving me one last chance to look upon the people who frighten me with their sickening cries. I hate it all, if they helped me through my storms they could've fixed what is now broken! But that has long past us, now look upon me with your deadly eyes, and hear my last words, &quot;Funny when you're dead how people start to listen.&quot; Now my body is limp and cold, savoring the surroundings of regrets of others. The pain and agony. &quot;Oh how she was such a good child!&quot; they'd all cry. &quot;She never deserved to die at such a young age!&quot; Is that so? Then tell me now before it's all over, do you believe what you say, or are you covering up your celebration with a splotchy red, and tearstained face? Tell me what I want to know before it's too late.</span>");
            showMessage("note-11a", false);
            break;
        case 'note-12':
            viewedNotes[12] = true;
            $("#noteBody").html("<span class='italics'>It's all I can think about. How someone else messes up and it automatically my fault. I find myself at fault for everything these days because that's all I know to think of myself. I'm the one that starts all fights and ends all roughing housing with getting someone hurt or something destroyed. And people ask me why I'm so upset all the time! They have the audacity to aska sad and lonely person why they're crying. I'd blame myself because I don't like blaming other people, but here's the thing, why do I blame myself for something I KNOW I didn't do? Ask the people who put punishments on me that make me think I did something wrong. I do something wrong when I'm not thinking, but when I'm angry or ticked off by something or someone, it isn't because I'm not thinking clearly, it's because no one in their right mind has the brains to ask me if I'm alright. No one has the heart to sit down and comfort me when I'm down. No one has the good sense to see that I'm not just trying to get attention, no one sees me as the sad and emotional girl that I am. They see a dramatic teenager, who makes everything seem like the end of the world.</span>");
            break;
        case 'note-12a':
            viewedNotes[13] = true;
            $("#noteBody").html("<span class='italics'>And I guess maybe I do exaggerate things, a little more than I need to at times, but that's just who I am. Take away all that exaggeration and all you'll see is a girl fighting away alone at every little struggle she faces. I'm more prepared to live on my own, than live with a mother who doesn't know how to help her own daughter. She loves me dearly. But the way she shows it is heartbreaking. She doesn't see how much her words can hurt a single being. Especially the one whom she knows takes everything to the next level. I know I'm rambling. I know I'm being dramatic and I'm crying. But this is probably the one true thing coming out of my mouth. I know my family loves me. But spare the disappointment for another time. Take it somewhere where it actually belongs instead of throwing it back at my face constantly. I don't need punishment or disicipline. I need care and comfort from my family. Not the wrongs and rights of the world. Because I already know how to handle those issues on my own. I'm good, and smart. But I'm also broken, and I feel abused although no one has laid a hand on me. But in a way, a very imaginative way, they have.</span>");
            showMessage("note-12a", false);
            break;
        case 'note-13':
            viewedNotes[14] = true;
            $("#noteBody").html("<strong>Pineapples</strong><br/><span class='italics'>Such a peculiar thing to think about but that's all I can manage to do. And it's not the fruit that interests me, I've never actually had a pineapple before, but it's the word. That very word that I had hoped would magically pop up on my phone screen with a random phone number on top it. But it's been already a day since the dream of fields and nightmares and the lucid thoughts that melted together to create a story that not only can I not share, I cannot remember. Some events that occured have reached my memory, but I can only hold onto them for a brief moment, before all of it fades into the back of my mind. This happens often. My mind is growing powerful as the days become longer and most of my childish dreams and everlasting fears have seemed to all have disappeared. I cannot explain it further than I already have, so I must continue on without it. I had a dream, sort of like this last one, but with a different plot. And not as extravagant, either. It was touching and left me in a state of wonderment for days. But it too, faded and I can no longer recall the amazingly wonderful dream.</span>");
            break;
        case 'note-14':
            viewedNotes[15] = true;
            $("#noteBody").html("<span class='italics'>It astounds me at how completely invisible I am to the student body. Teachers know me, but that's it. Nothing else. I want to leave middle school. But there's still 26 days left of the school year! Then that's 26 more days of adolecent hell.</span>");
            break;
        case 'note-15':
            viewedNotes[16] = true;
            $("#noteBody").html("<span class='italics'>Last day of school is almost over! My sister is picking me up then it's off to get ready for promotion!</span><br/>Excited-40%<br/>Nervous-60%");
            break;
        case 'note-16':
            viewedNotes[17] = true;
            $("#noteBody").html("<span class='italics'>Sometimes I don't want to wait the extra hour or two before my friend wakes up, sometimes I just want to pack up and leave. Sleepovers are not my favorite thing in the world. I like spending time with my friend, but she always wants me to stay over night. And I just physically can't. I like my home, where it smells like home and feels comfy. But when I'm at her house, I feel like I'm in a foreign place. I just want to go home to my own bed, I'm tired and I want to go home. I don't want to stay, I don't want to come back later, I want to go home and be alone or with my family. I want to go home and listen to music and watch my Undertale videos. I want to go home where I can actually be myself and not have to worry about watching over my friend. Just please, let me go home. I just want to go home. Please Kendyll, let me go home.</span>");
            break;
        case 'note-17':
            viewedNotes[18] = true;
            $("#noteBody").html("<span class='italics'>I know I don't do this often but I have to. Today I ranted/complained about how I wanted to go home and how I get annoyed everytime Kendyll wants me to sleepover. But I never thought I would have to rant about something else. Thank Penny for her comments and telling mom that I shouldn't have s'mores because I ate too much ice cream earlier. Even though my mom said I could still have some, I was disgusted with my actions and so the only thing I can think of doing right now is lay in my bed crying and telling myself that I messed up again, that I made a mistake again, that I'm a worthless, stupid, probelm causing, stress inducing, over eating, mistake of a teenage daughter. What could be a better way to spend my Saturday night? I always thought that my whole family were a bunch of bullies to me, but they're not the bully, I am.</span>");
            break;
        case 'note-18':
            viewedNotes[19] = true;
            $("#noteBody").html("<span class='italics'>I have no idea what mood I could possibly be in. I don't feel joy, sadness, anger, nothing. I'm numb, I guess.</span>");
            break;
        case 'note-19':
            viewedNotes[20] = true;
            $("#noteBody").html("<span class='italics'>I feel like I can't escape. I feel like I'm chained to the ground with no way out. I hate this feeling. It entangles itself around me, it chokes, it makes my lungs burn and my heart ache. It sets all my worst nightmares free. I live through most of it, but like any human, I have my moments of weakness. And today just marked one of them.</span>");
            break;
        case 'note-20':
            viewedNotes[21] = true;
            $("#noteBody").html("<span class='italics'>Congrats! Yah made! I hate this. High school, kind of, I don't know, SUCKS!</span>");
            break;
        case 'note-21':
            viewedNotes[22] = true;
            $("#noteBody").html("<span class='italics'>I hate everything, and everything hates me. That's how the world goes. That's how my life goes. It only gets worse. It only gets worse. There is no hope. There is no light. Because it only gets worse. My life motto everyone.</span>");
            break;
    }

    $("#notesList").hide();
    $("#photoGallery").hide();
    $('#noteModal').on('hidden.bs.modal', function () {
        $("#notesList").show();
    });
    $("#noteModal").modal();

    saveState();
});

var getMessageById = function(id) {

    for (var m=0; m < all_messages.length; m++) {
        if (all_messages[m].id == id) {

            return {
                "id": all_messages[m].id,
                "tag": all_messages[m].tag,
                "text": all_messages[m].text,
                "amberMessage": all_messages[m].amber,
                "gotoPage": all_messages[m].to ? all_messages[m].to : null,
                "options": all_messages[m].playerResponses ? all_messages[m].playerResponses : null,
                "viewed": all_messages[m].viewed
            };
        }
    }
};

var setMessageViewed = function(id) {

    for (var m=0; m < all_messages.length; m++) {
        if (all_messages[m].id == id) {
            all_messages[m].viewed = true;
            break;
        }
    }

};

var getMessageByTag = function(tag) {

    for (var m=0; m < all_messages.length; m++) {
        if (all_messages[m].tag == tag) {

            return {
                "id": all_messages[m].id,
                "tag": all_messages[m].tag,
                "text": all_messages[m].text,
                "amberMessage": all_messages[m].amber,
                "gotoPage": all_messages[m].to ? all_messages[m].to : null,
                "options": all_messages[m].playerResponses ? all_messages[m].playerResponses : null,
                "viewed": all_messages[m].viewed
            };
        }
    }
};

var showMessage = function(tag, isLoading) {
    console.info('showMessage( tag=' + tag + ', isLoading=' + isLoading.toString() + " )");

    var messageData = getMessageByTag(tag);

    if (!isLoading) {
        //
        // Player has seen this message...nothing to do...
        //
        if (!messageData.viewed) {
            displayedMessages.push(messageData.id);
            setMessageViewed(messageData.id);

            unreadMessageCount++;
            $.notify({
                // options
                message: messageData.text
            }, {
                // settings
                element: '#message-content',
                placement: {
                    align: 'center'
                },
                z_index: 1100,
                offset: {
                    x: 10,
                    y: 200
                },
                type: 'info'
            });
            updateMessageBadge(true, unreadMessageCount);
            saveState();
        }
    }
};

//
// Handler for player responses during opening conversation...
//
var conversation = function(id) {

};

var updateMessageBadge = function(show, cnt) {
    if (show) {
        $("#message-badge").text(cnt);
        $("#message-badge").show();
    } else {
        $("#message-badge").hide();
    }
};

$("#message-badge").hide();

var displayedMessages = [];
var unreadMessageCount = 0;
var viewedNotes = new Array(23);
var viewedPhotos = new Array(12);
var heardVoices = new Array(3);
var helloMessage = false;
var conversationStarted = true;
var storyBegins = true;
var restored = false;

$("#poem16").click(function() {
    showMessage("poem-16", false);
});

$("#poem9").click(function() {
    showMessage("poem-9", false);
});

$("#fbPhoto").click(function() {
    showMessage("footballPhoto", false);
});

$("#lucid").click(function() {
    showMessage("lucid", false);
});

$( document ).ready(function() {
    console.info('document.load()');

    for (var n=0; n < 23; n++)
        viewedNotes[n] = false;

    for (var m=0; m < 40; m++)
        all_messages[m].viewed = false;

    for (var p=0; p < 12; p++)
        viewedPhotos[p] = false;

    for (var v=0; v < 3; v++)
        heardVoices[v] = false;

    //
    // Only restore state if it's been saved already...
    //
    if (getCookie("restored") === 'true')
        restoreState();

    if (!helloMessage) {
        showMessage("amber-hello", false);
        $("#messages").trigger('click');
    }
});

/* Lock Screen */
$(function(){
    mhnUI.setup();
});
mhnUI = {
    pattern: "",
    setup: function() {
        this.lock(), this.filter(), this.colors(), this.links.setup(), this.dialog.setup(), setInterval("mhnUI.datetime()", 1e3)
    },
    lock: function() {
        mhnUI.page.hide(), pattern = new PatternLock(".mhn-lock", {
            margin: 15
        }), $(".mhn-lock-title").html($(".mhn-lock-title").data("title")), pattern.checkForPattern("7415369", function() {
            $(".mhn-lock-title").html('<span class="mhn-lock-success">Yes! you unlocked pattern</span>'), $(".patt-holder").addClass("patt-success"), setTimeout(function() {
                pattern.reset(), mhnUI.message()
            }, 1e3), mhnUI.page.show()
        }, function() {
            $(".mhn-lock-title").html('<span class="mhn-lock-failure">Opps! pattern is not correct</span>'), $(".patt-holder").removeClass("patt-success"), setTimeout(function() {
                pattern.reset(), mhnUI.message()
            }, 2e3)
        })
    },
    message: function() {
        // $(".mhn-lock-title span").fadeOut(), setTimeout(function() {
        //     $(".mhn-lock-title").html($(".mhn-lock-title").data("title")), $(".mhn-lock-title span").fadeIn()
        // }, 500)
    },
    datetime: function() {
        var t = new Array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"),
            e = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"),
            n = new Date,
            i = n.getYear();
        1e3 > i && (i += 1900);
        var a = n.getDay(),
            o = n.getMonth(),
            s = n.getDate();
        10 > s && (s = "0" + s);
        var h = n.getHours(),
            c = n.getMinutes(),
            u = n.getSeconds(),
            l = "AM";
        h >= 12 && (l = "PM"), h > 12 && (h -= 12), 0 == h && (h = 12), 9 >= c && (c = "0" + c), 9 >= u && (u = "0" + u), $(".mhn-ui-date-time .mhn-ui-day").text(t[a]), $(".mhn-ui-date-time .mhn-ui-date").text(e[o] + " " + s + ", " + i), $(".mhn-ui-date-time .mhn-ui-time").text(h + ":" + c + " " + l), $(".mhn-ui-app-time").text(h + ":" + c + ":" + u + " " + l)
    },
    page: {
        show: function(t) {
            t = t ? t : "page-home", $(".mhn-ui-wrap").hide(),
                    helloMessage = true,
                    saveState()
        },
        hide: function(t) {
            t = t ? t : "page-lock", $(".mhn-ui-page").hide(), $(".mhn-ui-page." + t).show()
        }
    },
    filter: function() {
        $(".mhn-ui-filter .mhn-ui-btn").click(function() {
            $(this).toggleClass("active"), $(".mhn-ui-filter-list").toggle(100)
        }), $(".mhn-ui-filter-list>div").click(function() {
            var t = $(this).data("filter");
            $(this).siblings().removeAttr("class"), $(this).addClass("active");
            var e = function(t) {
                $(".mhn-ui-apps .mhn-ui-col").fadeOut(400), $('.mhn-ui-apps .mhn-ui-col[data-filter="' + t + '"]').fadeIn(400)
            };
            switch (t) {
                case "all":
                    $(".mhn-ui-apps .mhn-ui-col").fadeIn(400);
                    break;
                case "general":
                    e(t);
                    break;
                case "social":
                    e(t);
                    break;
                case "credits":
                    e(t)
            }
            $(".mhn-ui-filter-list").toggle(100), $(".mhn-ui-filter .mhn-ui-btn").removeClass("active"), $(".mhn-ui-page-title").text($(this).text())
        })
    },
    colors: function() {
        $(".mhn-ui-icon span").on("mouseover", function() {
            $(this).css("background", $(this).data("color"))
        }).on("mouseout", function() {
            $(this).removeAttr("style")
        })
    },
    links: {
        setup: function() {
            $(".mhn-ui-apps .mhn-ui-icon").click(function() {
                var t = $(this).data("href"),
                    e = $(this).data("open");
                t && mhnUI.links.href(t), e && mhnUI.page.show(e)
            })
        },
        href: function(t) {
            mhnUI.dialog.show(t)
        }
    },
    dialog: {
        setup: function() {
            $('.mhn-ui-dialog-wrap,.mhn-ui-dialog-wrap a[data-action="cancel"]').click(function() {
                mhnUI.dialog.hide()
            }), $(".mhn-ui-dialog").click(function(t) {
                t.stopPropagation()
            }), $('.mhn-ui-dialog a[data-action="confirm"]').click(function() {
                setTimeout(function() {
                    mhnUI.dialog.hide()
                }, 400)
            })
        },
        show: function(t) {
            $('.mhn-ui-dialog-wrap a[data-action="confirm"]').attr("href", t), $(".mhn-ui-dialog-wrap").show()
        },
        hide: function() {
            $('.mhn-ui-dialog-wrap a[data-action="confirm"]').removeAttr("href"), $(".mhn-ui-dialog-wrap").fadeOut(400)
        }
    }
};

/*
    patternLock.js v 0.5.0
    Author: Sudhanshu Yadav
    Copyright (c) 2015 Sudhanshu Yadav - ignitersworld.com , released under the MIT license.
    Demo on: ignitersworld.com/lab/patternLock.html
*/
!function(t,e,n,a){"use strict";function r(t){for(var e=t.holder,n=t.option,a=n.matrix,r=n.margin,i=n.radius,o=['<ul class="patt-wrap" style="padding:'+r+'px">'],s=0,l=a[0]*a[1];l>s;s++)o.push('<li class="patt-circ" style="margin:'+r+"px; width : "+2*i+"px; height : "+2*i+"px; -webkit-border-radius: "+i+"px; -moz-border-radius: "+i+"px; border-radius: "+i+'px; "><div class="patt-dots"></div></li>');o.push("</ul>"),e.html(o.join("")).css({width:a[1]*(2*i+2*r)+2*r+"px",height:a[0]*(2*i+2*r)+2*r+"px"}),t.pattCircle=t.holder.find(".patt-circ")}function i(t,e,n,a){var r=e-t,i=a-n;return{length:Math.ceil(Math.sqrt(r*r+i*i)),angle:Math.round(180*Math.atan2(i,r)/Math.PI)}}function o(){}function s(e,n){var a=this,i=a.token=Math.random(),h=p[i]=new o,u=h.holder=t(e);if(0!=u.length){h.object=a,n=h.option=t.extend({},s.defaults,n),r(h),u.addClass("patt-holder"),"static"==u.css("position")&&u.css("position","relative"),u.on("touchstart mousedown",function(t){d.call(this,t,a)}),h.option.onDraw=n.onDraw||l;var c=n.mapper;h.mapperFunc="object"==typeof c?function(t){return c[t]}:"function"==typeof c?c:l,h.option.mapper=null}}var l=function(){},p={},d=function(e,a){e.preventDefault();var r=p[a.token];if(!r.disabled){r.option.patternVisible||r.holder.addClass("patt-hidden");var i="touchstart"==e.type?"touchmove":"mousemove",o="touchstart"==e.type?"touchend":"mouseup";t(this).on(i+".pattern-move",function(t){h.call(this,t,a)}),t(n).one(o,function(){u.call(this,e,a)});var s=r.holder.find(".patt-wrap"),l=s.offset();r.wrapTop=l.top,r.wrapLeft=l.left,a.reset()}},h=function(e,n){e.preventDefault();var a=e.pageX||e.originalEvent.touches[0].pageX,r=e.pageY||e.originalEvent.touches[0].pageY,o=p[n.token],s=o.pattCircle,l=o.patternAry,d=o.option.lineOnMove,h=o.getIdxFromPoint(a,r),u=h.idx,c=o.mapperFunc(u)||u;if(l.length>0){var f=i(o.lineX1,h.x,o.lineY1,h.y);o.line.css({width:f.length+10+"px",transform:"rotate("+f.angle+"deg)"})}if(u){if(-1==l.indexOf(c)){var v,m=t(s[u-1]);if(o.lastPosObj){for(var g=o.lastPosObj,x=g.i,w=g.j,b=Math.abs(h.i-x),j=Math.abs(h.j-w);(0==b&&j>1||0==j&&b>1||j==b&&j>1)&&(w!=h.j||x!=h.i);){x=b?Math.min(h.i,x)+1:x,w=j?Math.min(h.j,w)+1:w,b=Math.abs(h.i-x),j=Math.abs(h.j-w);var M=(w-1)*o.option.matrix[1]+x,y=o.mapperFunc(M)||M;-1==l.indexOf(y)&&(t(s[M-1]).addClass("hovered"),l.push(y))}v=[],h.j-g.j>0?v.push("s"):h.j-g.j<0?v.push("n"):0,h.i-g.i>0?v.push("e"):h.i-g.i<0?v.push("w"):0,v=v.join("-")}m.addClass("hovered"),l.push(c);var P=o.option.margin,k=o.option.radius,C=(h.i-1)*(2*P+2*k)+2*P+k,O=(h.j-1)*(2*P+2*k)+2*P+k;if(1!=l.length){var D=i(o.lineX1,C,o.lineY1,O);o.line.css({width:D.length+10+"px",transform:"rotate("+D.angle+"deg)"}),d||o.line.show()}v&&(o.lastElm.addClass(v+" dir"),o.line.addClass(v+" dir"));var E=t('<div class="patt-lines" style="top:'+(O-5)+"px; left:"+(C-5)+'px"></div>');o.line=E,o.lineX1=C,o.lineY1=O,o.holder.append(E),d||o.line.hide(),o.lastElm=m}o.lastPosObj=h}},u=function(t,e){t.preventDefault();var n=p[e.token],a=n.patternAry.join("");n.holder.off(".pattern-move").removeClass("patt-hidden"),a&&(n.option.onDraw(a),n.line.remove(),n.rightPattern&&(a==n.rightPattern?n.onSuccess():(n.onError(),e.error())))};o.prototype={constructor:o,getIdxFromPoint:function(t,e){var n=this.option,a=n.matrix,r=t-this.wrapLeft,i=e-this.wrapTop,o=null,s=n.margin,l=2*n.radius+2*s,p=Math.ceil(r/l),d=Math.ceil(i/l),h=r%l,u=i%l;return p<=a[1]&&d<=a[0]&&h>2*s&&u>2*s&&(o=(d-1)*a[1]+p),{idx:o,i:p,j:d,x:r,y:i}}},s.prototype={constructor:s,option:function(t,e){var n=p[this.token],i=n.option;return e===a?i[t]:(i[t]=e,void(("margin"==t||"matrix"==t||"radius"==t)&&r(n)))},getPattern:function(){return p[this.token].patternAry.join("")},setPattern:function(t){var e=p[this.token],n=e.option,a=n.matrix,r=n.margin,i=n.radius;if(n.enableSetPattern){this.reset(),e.wrapLeft=0,e.wrapTop=0;for(var o=0;o<t.length;o++){var s=t[o]-1,d=s%a[1],u=Math.floor(s/a[1]),c=d*(2*r+2*i)+2*r+i,f=u*(2*r+2*i)+2*r+i;h.call(null,{pageX:c,pageY:f,preventDefault:l,originalEvent:{touches:[{pageX:c,pageY:f}]}},this)}}},enable:function(){var t=p[this.token];t.disabled=!1},disable:function(){var t=p[this.token];t.disabled=!0},reset:function(){var t=p[this.token];t.pattCircle.removeClass("hovered dir s n w e s-w s-e n-w n-e"),t.holder.find(".patt-lines").remove(),t.patternAry=[],t.lastPosObj=null,t.holder.removeClass("patt-error patt-success")},error:function(){p[this.token].holder.addClass("patt-error")},checkForPattern:function(t,e,n){var a=p[this.token];a.rightPattern=t,a.onSuccess=e||l,a.onError=n||l}},s.defaults={matrix:[3,3],margin:20,radius:25,patternVisible:!0,lineOnMove:!0,enableSetPattern:!1},e.PatternLock=s}(jQuery,window,document);
